import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define colors for statuses
floor_color = 'lightblue'
passenger_waiting_color = 'green'
elevator_available_color = 'green'
elevator_full_color = 'red'

# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define floor positions
floors = ['n0', 'n1', 'n2', 'n3', 'n4']
floor_height = 1
floor_width = 6
elevator_width = 0.5
elevator_height = 0.5
passenger_width = 0.3
passenger_height = 0.3

# Draw floors
for i, floor in enumerate(floors):
    y = i * floor_height
    ax.add_patch(patches.Rectangle((0, y), floor_width, floor_height, facecolor=floor_color))
    ax.text(0.5, y + 0.5, f'floor_{floor}', va='center', ha='center', fontsize=8, color='black')

# Draw passengers
passengers = {
    'p0': ('n1', 0),
    'p1': ('n3', 0),
    'p2': ('n0', 0),
    'p3': ('n0', 1),
    'p4': ('n3', 1),
    'p5': ('n1', 1)
}

for p, (floor, pos) in passengers.items():
    y = floors.index(floor) * floor_height
    x = pos * (passenger_width + 0.1)
    ax.add_patch(patches.Rectangle((x, y + 0.35), passenger_width, passenger_height, facecolor=passenger_waiting_color))
    ax.text(x + 0.15, y + 0.5, p, va='center', ha='center', fontsize=6, color='black')

# Draw elevators
elevators = {
    'fast0': ('n0', 'fast', 0, 2),
    'fast1': ('n0', 'fast', 0, 2),
    'slow0-0': ('n0', 'slow', 0, 1),
    'slow1-0': ('n2', 'slow', 0, 1)
}

for e, (floor, etype, current, capacity) in elevators.items():
    y = floors.index(floor) * floor_height
    if etype == 'fast':
        x = floor_width - elevator_width - 0.1
    else:
        x = floor_width - 2 * elevator_width - 0.2

    color = elevator_available_color if current < capacity else elevator_full_color
    ax.add_patch(patches.Rectangle((x, y + 0.25), elevator_width, elevator_height, facecolor=color))
    ax.text(x + 0.25, y + 0.5, f'{e}\n{current}<PATH_REMOVED>', va='center', ha='center', fontsize=6, color='black')

# Create legend
legend_elements = [
    patches.Patch(facecolor=passenger_waiting_color, edgecolor='black', label='Passenger Waiting'),
    patches.Patch(facecolor=elevator_available_color, edgecolor='black', label='Elevator Available'),
    patches.Patch(facecolor=floor_color, edgecolor='black', label='Floor')
]

ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.2, 1), fontsize=8)

# Set limits and remove axes
ax.set_xlim(-0.5, floor_width + 1)
ax.set_ylim(-0.5, len(floors) * floor_height)
ax.axis('off')

# Save the figure
plt.savefig('elevator/one_shot/ini_diagram_code/attempts/attempt_13.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# Fast elevators are missing from the diagram.
